<?php
/*
Plugin Name: HA SIMPLE POST LIST
Plugin URI: https://www.momosiri.info/
Description: Simple Post List With Shortcode
[ha_posts_list offset="" type="" num="" order="" cat=""]を挿入することで、単純なタイトルと最終更新日の入ったリストが作れる
Author: hima-art
Version: 1.3.1
Author URI: https://www.momosiri.info/
*/

/*  1.3
記事リストにカスタムCSS(ccss)パラメーター追加
mod条件をNew条件でない場合、かつ、Mod条件に当てはまるかへ変更
NEW Modifiedの文字列をパラメーターで変更可能に
*/

/* 1.3.1
CSS調整
*/

/* https://wpdocs.osdn.jp/%E3%83%86%E3%83%B3%E3%83%97%E3%83%AC%E3%83%BC%E3%83%88%E3%82%BF%E3%82%B0/get_posts#.E3.82.BF.E3.82.AF.E3.82.BD.E3.83.8E.E3.83.9F.E3.83.BC.E3.83.91.E3.83.A9.E3.83.A1.E3.83.BC.E3.82.BF 
*/

/***** サイト内投稿リスト *****/
if ( !function_exists( 'ha_simple_posts_list' ) ){
function ha_simple_posts_list($atts, $content = null) {
	
	global $post;
	extract(shortcode_atts(array(
		'cat'     => '',
		'tag'    => '',
		'num'     => '5',
		'order'   => 'DESC',
		'orderby' => 'modified',
		'offset' => '0',
		'type' => 'any',
		'ndays' => '7',
		'ccss' => '',
		'nmark' => 'NEW',
		'modmark' => 'Modified',
	), $atts));
	
	$args = array(
		'cat'            => explode( ',', $cat ),
		'tag'            => explode( ',', $tag ),
		'posts_per_page' => $num,
		'order'          => $order,
		'orderby'        => $orderby,
		'post_type'        => explode( ',', $type ),
		'offset'    => $offset,
		'ndays' => $ndays,
		'ccss' => $ccss,
		'nmark' => $nmark,
		'modmark' => $modmark,
		
	);
	
	$output = '';
	
	$posts = get_posts($args);
	
	foreach($posts as $post) {
		
		setup_postdata($post);
		
		
	//最終更新日から7日以内のものに「New」マークを付ける
		$post_time = get_the_time('U');
		$post_mod_time =  get_the_modified_time('U');
		$days = $ndays; //New!を表示させる日数
		$last = time() - ($days * 24 * 60 * 60);
			if ($post_time > $last) {
				//nmarkパラメーターがあるかどうかで分岐
				if(empty($nmark)){
					$output_new = '<span class="ha-new-txt">NEW</span>';
				}else{
					$output_new = '<span class="ha-new-txt">'.$nmark.'</span>';
				}
			}else{
				$output_new = '';
			}
			if ($post_time < $last && $post_mod_time > $last) {
				//modmarkパラメーターがあるかどうかで分岐
				if(empty($modmark)){
					$output_mod = '<span class="ha-mod-txt">Modified</span>';
				}else{
					$output_mod = '<span class="ha-mod-txt">'.$modmark.'</span>';
				}
			}else{
				$output_mod = '';
			}

	$output .= '<li>'.$output_new. $output_mod.'<a href="'. get_the_permalink() .'">' .get_the_title() .'</a><span class="md-date"> - '.get_the_modified_date().'- </span></li>';
	}

	wp_reset_postdata();

	return '<div class="ha-post-list-sc '.$ccss.'"><ul>'. $output .'</ul></div>';

}
}

add_shortcode('ha_posts_list', 'ha_simple_posts_list');


/***** RSSフィードショートコード *****/
if ( !function_exists( 'ha_simple_feeds_list' ) ){
function ha_simple_feeds_list( $atts ) {
	include_once( ABSPATH . WPINC . '/feed.php' );
	$blog_rss = shortcode_atts( array(
		'url' => 'https://www.momosiri.info/feed/',
		'num' => '5',
		'ndays' => '7',
		'nmark' => '',
		'ccss' => '',
		),
		$atts );

	$feed_url = explode( ',', $blog_rss['url'] );
	$feed_num = $blog_rss['num'];
	$feed_ccss = $blog_rss['ccss'];
	$feed_content = '';
	$feed_contents = '';
	$rss = fetch_feed( $feed_url );
	if(empty($blog_rss['ndays'])){
		$ndays = '7';
	}else{
		$ndays = $blog_rss['ndays'];
	}
	
	$nmark = $blog_rss['nmark'];

	if ( !is_wp_error( $rss ) ) :
		$maxitems = $rss->get_item_quantity( $feed_num );
		$rss_items = $rss->get_items( 0, $maxitems );

	foreach ( $rss_items as $item ) :
		$feed_url = $item->get_permalink();
		$feed_title = $item->get_title();
		$feed_date = $item->get_date(get_option( 'date_format' ));

	//RSSフィード中の日付から7日以内のものに「New」マークを付ける
		$hafeed_time = $item->get_date('U');
		$hafeed_days = $ndays; //New!を表示させる日数
		$hafeed_now = date('U');
		$hafeed_last = $hafeed_now - ($hafeed_days * 24 * 60 * 60);
		if ($hafeed_time > $hafeed_last) {
			if(empty($nmark)){
				$output_rss_new = '<span class="ha-new-txt">New</span>';
			}else{
				$output_rss_new = '<span class="ha-new-txt">'.$nmark.'</span>';
			}
		}else{
			$output_rss_new = '';
		}

	$feed_content .= '<li>'.$output_rss_new.'<a rel="noopener" href="'. $feed_url . '" title="' . $feed_title . '" class="rsscard-wrap" target="_blank">'.$feed_title .'</a>';
	$feed_content .= '<span class="md-date"> - ' . $feed_date . ' - </span></li>';

	endforeach;
	else:
	$feeddesc_lang = __('Unable to get RSS feed','ha-simple-post-list');
	$feed_content = '<p>'.$feeddesc_lang.'</p>';
	endif;

	$feed_contents = '<div class="ha-post-list-sc '.$feed_ccss.'"><ul>' . $feed_content . '</ul></div>';

return "{$feed_contents}";
}
}

add_shortcode( 'ha_feeds_list', 'ha_simple_feeds_list' );


/***** スタイルを追加 *****/
if ( !function_exists( 'ha_simple_posts_shortcode_styles' ) ){
function ha_simple_posts_shortcode_styles() {
	wp_enqueue_style( 'ha-simple-post-list-style', plugin_dir_url( __FILE__ ) . '/postlist.css', array(), '1.0.0'
);
}
}

add_action( 'wp_enqueue_scripts', 'ha_simple_posts_shortcode_styles');

/***** カテゴリー一覧へIDを表示 *****/
if ( !function_exists( 'habone_add_category_columns' ) ){
function habone_add_category_columns( $columns ) {
	echo '<style>
	.taxonomy-category .manage-column.num {width: 100px;}
	.taxonomy-category .manage-column.column-id {width: 50px;}
	</style>';

	$columns['id'] = 'ID';
	return $columns;
}
}

/*** id in category list ***/
if ( !function_exists( 'habone_custom_category_column' ) ){
function habone_custom_category_column( $content, $column_name, $term_id ) {
	if ( $column_name == 'id' ) {
	echo $term_id;
	}
}
}
add_filter( 'manage_edit-category_columns', 'habone_add_category_columns' );
add_action( 'manage_category_custom_column', 'habone_custom_category_column', 10, 3 );

?>