<?php
/*
Plugin Name: HA BLOCK DESIGN
Plugin URI: https://www.momosiri.info/
Description: Designed Paragraph & List
Author: hima-art
Version: 1.0
Author URI: https://www.momosiri.info/
*/


/*** テーブルブロックに枠線ありのスタイルを追加 ***/
if ( !function_exists( 'hab_table_design_border_dark' ) ):
function hab_table_design_border_dark() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/table', {
  name: 'border',
  label: '枠あり'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_table_design_border_dark' );
endif;

/*** 段落ブロックにボックススタイルを追加 ***/
/* 警告ボックス */
if ( !function_exists( 'hab_p_worning_design' ) ):
function hab_p_worning_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/paragraph', {
name: 'ha-para-warning',
label: '警告'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_p_worning_design' );
endif;

/* 注意ボックス */
if ( !function_exists( 'hab_p_notice_design' ) ):
function hab_p_notice_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/paragraph', {
name: 'ha-para-notice',
label: '注意'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_p_notice_design' );
endif;

/* アイディアボックス */
if ( !function_exists( 'hab_p_idea_design' ) ):
function hab_p_idea_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/paragraph', {
name: 'ha-para-idea',
label: 'アイディア'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_p_idea_design' );
endif;

/* チェックボックス */
if ( !function_exists( 'hab_p_info_design' ) ):
function hab_p_info_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/paragraph', {
name: 'ha-para-info',
label: 'チェック'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_p_info_design' );
endif;

/*** リストブロックにボックススタイルを追加 ***/
/* 警告リスト */
if ( !function_exists( 'hab_list_worning_design' ) ):
function hab_list_worning_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-list-warning',
label: '警告リスト'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_list_worning_design' );
endif;

/* 注意リスト */
if ( !function_exists( 'hab_list_notice_design' ) ):
function hab_list_notice_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-list-notice',
label: '注意リスト'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_list_notice_design' );
endif;

/* アイディアリスト */
if ( !function_exists( 'hab_list_idea_design' ) ):
function hab_list_idea_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-list-idea',
label: 'アイディアリスト'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_list_idea_design' );
endif;

/* チェックリスト */
if ( !function_exists( 'hab_list_info_design' ) ):
function hab_list_info_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-list-info',
label: 'チェックリスト'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_list_info_design' );
endif;


/* 数字リスト赤 */
if ( !function_exists( 'hab_decimal_list_worning_design' ) ):
function hab_decimal_list_worning_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-decimal-list-warning',
label: '数字リスト赤'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_decimal_list_worning_design' );
endif;

/* 数字リスト黄 */
if ( !function_exists( 'hab_decimal_list_notice_design' ) ):
function hab_decimal_list_notice_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-decimal-list-notice',
label: '数字リスト黄'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_decimal_list_notice_design' );
endif;



/* 数字リスト緑 */
if ( !function_exists( 'hab_decimal_list_info_design' ) ):
function hab_decimal_list_info_design() {
	$script = <<<SCRIPT
wp.blocks.registerBlockStyle('core/list', {
name: 'ha-decimal-list-info',
label: '数字リスト緑'
});
SCRIPT;
	wp_add_inline_script( 'wp-blocks', $script );
}
add_action( 'enqueue_block_editor_assets', 'hab_decimal_list_info_design' );
endif;

/** スタイルシートを適用 **/
if ( !function_exists( 'ha_block_design_styles' ) ):
function ha_block_design_styles() {
	wp_enqueue_style( 'ha-block-design-style', plugin_dir_url( __FILE__ ) . '/style.css', array(), '1.0.0'
);
//icomoonのCSS
	wp_enqueue_style( 'habd-icomoon-style', plugin_dir_url( __FILE__ ) . '/icomoon/style.css', array(), '1.0.0' );
}
endif;
add_action( 'wp_enqueue_scripts', 'ha_block_design_styles');

/** スタイルシートをエディタへ適用 **/
if ( !function_exists( 'ha_block_design_admin_styles' ) ):
function ha_block_design_admin_styles() {
	wp_enqueue_style( 'habda-block-editor-style', plugin_dir_url( __FILE__ ). '/style.css'  );
//icomoonのCSS
	wp_enqueue_style( 'habda-icomoon-style', plugin_dir_url( __FILE__ ) . '/icomoon/style.css' );
}
endif;
add_action( 'enqueue_block_editor_assets', 'ha_block_design_admin_styles' );

?>